autowatch = 1
outlets = 2
mgraphics.init()
mgraphics.autofill = 0
mgraphics.relative_coords = 0

var colors = []
var focused = null

var filteredColors = [
	"Alert",
	"Arranger Grid Tiles",
	"Automation",
	"Automation Override",
	"Control Background",
	"Control Border",
	"Control Handle",
	"Control Header",
	"Control Highlight",
	"Control Highlight Standby",
	"Control Needle Off",
	"Control Needle On",
	"Control Off",
	"Control On",
	"Control On (Inactive)",
	"Control On Variant",
	"Control On Variant",
	"Control Range Off",
	"Control Range Off (Inactive)",
	"Control Range On",
	"Control Range On (Inactive)",
	"Control Selection Frame",
	"Control Triangle",
	"Desktop",
	"Device Background",
	"Freeze",
	"Gain Reduction",
	"Line",
	"Input Curve",
	"Input Curve Outline",
	"LCD Background",
	"LCD Background Text",
	"LCD Handle",
	"LCD Handle Variant",
	"LCD Line",
	"LCD Shape",
	"LCD Shape Variant",
	"LCD Text / Icon",
	"LCD Text / Icon (Inactive)",
	"LCD Text / Icon Variant",
	"LCD Title",
	"LED Background",
	"Line",
	"Mapping Highlight",
	"Mapping Key",
	"Mapping Macro",
	"Mapping Midi",
	"Modulation",
	"Numbox Triangle",
	"Output Curve",
	"Output Curve",
	"Outline",
	"Play",
	"PreListen",
	"Record",
	"Slider Range Value",
	"Slider Range Value Variant 2",
	"Slider Range Value Variant 3",
	"Spectrum",
	"Spectrum Grid Spectrum Variant",
	"Surface Frame Focus",
	"Text / Icon",
	"Text / Icon Off",
	"Text / Icon Off (Inactive)",
	"Text / Icon On",
	"Text / Icon On (Inactive)",
	"Text / Icon On Standby",
	"Text Background",
	"Threshold Line",
	"Bug Text",
	"Error Background",
	"Error Text",
	"Print Text",
	"Success Text",
	"Background Stripe Color",
	"Bubble Background Color",
	"Bubble Outline Color",
	"Comment Background Color",
	"Comment Text Color",
	"Locked Patcher Background Color",
	"Object Accent Color",
	"Object Background Color",
	"Object Color",
	"Object Element Color",
	"Object Selection Color",
	"Object Text Color",
	"Patchline Color",
	"Unlocked Patcher Background Color"
];

function loadbang() {
	var maxColorDictionary = new Dict;
	maxColorDictionary.import_json('maxcolors.json');
	
	var allColors = JSON.parse(maxColorDictionary.stringify())
	colors = allColors.colors.filter(function(color) {
		return color.category !== "Unused" && color.visibility == 'essential';
	});

	// sort colors by category and then alphabetically by color.label
	colors.sort(function(a, b) {
		if (a.category < b.category) {
			return -1
		} else if (a.category > b.category) {
			return 1
		} else {
			return a.label < b.label ? -1 : 1
		}
	})
}

loadbang()

var entryHeight = 20
var entryWidth = 150

function paint() {
	var [width, height] = getBoxSize()
	var rectanglesPerRow = Math.floor(width / entryWidth)

	colors.forEach(function(color, i) {
		// Determine where to draw the entry depending on the width and height of the JSUI box
		var row = Math.floor(i / rectanglesPerRow)
		var col = i % rectanglesPerRow

		var x = col * entryWidth
		var y = row * entryHeight

		with (mgraphics) {
			// Draw a square representing the color
			set_source_rgba(color.oncolor)
			rectangle(x, y, entryWidth, entryHeight)
			fill()

			// Measure how long the token name's text will be
			var [textWidth, textHeight] = text_measure(color.label)

			// Set the colour of the text to black or white depending on luminance
			set_source_rgba(getTextColor(color.oncolor, 0.5))

			// Setup the font size and type
			select_font_face('Ableton Sans Medium')
			set_font_size(10)
			set_line_width(1)
			
			// Draw the text over the entry square
			move_to(x + 5, y + entryHeight - (textHeight / 2))
			show_text(color.label)

			// If the entry is focused, draw a little box to emphasise it.
			if (focused == i) {
				set_line_width(2)
				set_source_rgba(0, 0, 0, 1.0)
				rectangle(x, y, entryWidth, entryHeight)
				stroke()
			}
		}
	});
}

function whichColorHovered(x, y) {
	// This function determines if the mouse is hovering over a color entry
	// It uses the x/y coordinates of the mouse while dragging and clicking
	var [width, height] = getBoxSize()
	var rectanglesPerRow = Math.floor(width / entryWidth)

	var col = Math.floor(x / entryWidth)
	var row = Math.floor(y / entryHeight)

	var index = row * rectanglesPerRow + col

	if (index >= 0 && index < colors.length) {
		var clickedColor = colors[index]
		outlet(0, clickedColor.id)
		var outputDict = new Dict
		outputDict.parse(JSON.stringify(clickedColor))
		outlet(1, 'dictionary', outputDict.name)
		return [clickedColor, index]
	}
}

function onclick(x, y, but) {
	var [color, index] = whichColorHovered(x, y)
	if (but) {
		focused = index
		mgraphics.redraw()
	}
}

function ondrag(x, y, but) {
	var [color, index] = whichColorHovered(x, y)
	focused = !but ? null : index
	mgraphics.redraw()
}

function getBoxSize () {
	// A handy function for getting the width and height of the JSUI box
    var width = this.box.rect[2] - this.box.rect[0]
    var height = this.box.rect[3] - this.box.rect[1]
    return [width, height]
}

function getTextColor(bgColor, threshold) {
	// This function determines the color of the text based on the luminance of the background color
	var [r, g, b] = bgColor;

    // Calculate the luminance of the color
    var luminance = 0.299 * r + 0.587 * g + 0.114 * b;

    // If the luminance is greater than 0.5, return black; otherwise, return white
    return luminance > threshold ? [0, 0, 0, 1] : [1, 1, 1, 1];
}



